//+------------------------------------------------------------------+
//|                                               output_history.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
#property show_inputs
extern   datetime   FromDateTime    = D'2011.07.01 00:00';
extern   datetime   ThruDateTime    = D'2020.12.31 00:00';
//+------------------------------------------------------------------+
//| script program start function                                    |
//+------------------------------------------------------------------+
int start()
  {
  //Export(Symbol(),Period()); add your additional symbols below
  Export("AUDUSD",1);
  Export("AUDCAD",1);
  Export("AUDJPY",1);   
  Export("AUDNZD",1); 
  Export("CADCHF",1);
  Export("CADJPY",1);
  Export("CHFJPY",1);
  Export("EURUSD",1);
  Export("EURCAD",1); 
  Export("EURCHF",1); 
  Export("EURGBP",1);
  Export("EURJPY",1);
  Export("EURNZD",1);
  Export("EURAUD",1);      
  Export("GBPAUD",1);
  Export("GBPCAD",1);
  Export("GBPCHF",1);
  Export("GBPJPY",1);
  Export("GBPNZD",1);
  Export("GBPUSD",1);
  Export("NZDUSD",1);
  Export("NZDCAD",1);
  Export("NZDJPY",1); 
  Export("USDCHF",1);
  Export("USDCAD",1);
  Export("USDJPY",1);
  
  return(0);
  }

int Export(string pair, int tf)
{
  string fname = pair + /*"," + tf +*/ ".csv";
 
  int handle = FileOpen(fname, FILE_CSV|FILE_WRITE, ",");
  if(handle>0)
    {
     for(int i=iBars(pair,tf)-1; i>=0; i--)
       {
       datetime dtval = iTime(pair,tf,i);
       if (dtval < FromDateTime || dtval > ThruDateTime || TimeDayOfWeek( dtval ) == 6 || 
       (TimeDayOfWeek(dtval) == 5 && TimeHour(dtval) > 16) || (TimeDayOfWeek(dtval) == 0 && TimeHour(dtval) < 18 ) ) continue;
       string date1 = TimeToStr(iTime(pair,tf,i),TIME_DATE);
       date1 = StringSubstr(date1, 0, 4) + "." + StringSubstr(date1, 5, 2) + "." + StringSubstr(date1, 8, 2) ;
       string time1 = TimeToStr(iTime(pair,tf,i),TIME_MINUTES);
       FileWrite(handle, /*pair,*/ date1, time1, iOpen(pair,tf,i), iHigh(pair,tf,i), iLow(pair,tf,i), iClose(pair,tf,i), iVolume(pair,tf,i) );
       }
     FileClose(handle);
     Comment("History export complete");
    }
   return(0);
  }

